/*
 * Decompiled with CFR 0.152.
 */
package tech.feldman.betterrecords.block;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.feldman.betterrecords.api.record.IRecordAmplitude;
import tech.feldman.betterrecords.api.wire.IRecordWire;
import tech.feldman.betterrecords.block.ItemModelProvider;
import tech.feldman.betterrecords.block.ModBlock;
import tech.feldman.betterrecords.block.TESRProvider;
import tech.feldman.betterrecords.block.tile.TileStrobeLight;
import tech.feldman.betterrecords.client.render.RenderStrobeLight;
import tech.feldman.betterrecords.helper.ConnectionHelper;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J&\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016\u00a8\u0006 "}, d2={"Ltech/feldman/betterrecords/block/BlockStrobeLight;", "Ltech/feldman/betterrecords/block/ModBlock;", "Ltech/feldman/betterrecords/block/TESRProvider;", "Ltech/feldman/betterrecords/block/tile/TileStrobeLight;", "Ltech/feldman/betterrecords/block/ItemModelProvider;", "name", "", "(Ljava/lang/String;)V", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "state", "Lnet/minecraft/block/state/IBlockState;", "block", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getLightValue", "", "access", "getRenderClass", "Lkotlin/reflect/KClass;", "Ltech/feldman/betterrecords/client/render/RenderStrobeLight;", "getTileEntityClass", "onBlockAdded", "", "world", "Lnet/minecraft/world/World;", "removedByPlayer", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "willHarvest", "BetterRecords"})
public final class BlockStrobeLight
extends ModBlock
implements TESRProvider<TileStrobeLight>,
ItemModelProvider {
    @Override
    @NotNull
    public KClass<TileStrobeLight> getTileEntityClass() {
        return Reflection.getOrCreateKotlinClass(TileStrobeLight.class);
    }

    @Override
    @NotNull
    public KClass<RenderStrobeLight> getRenderClass() {
        return Reflection.getOrCreateKotlinClass(RenderStrobeLight.class);
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@Nullable IBlockState state, @Nullable IBlockAccess block, @Nullable BlockPos pos) {
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.74);
    }

    public int getLightValue(@NotNull IBlockState state, @NotNull IBlockAccess access, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)access, (String)"access");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        TileEntity te = access.func_175625_s(pos);
        if (te == null || !(te instanceof IRecordWire) || !(te instanceof IRecordAmplitude)) {
            return 0;
        }
        return ((IRecordWire)te).getConnections().size() > 0 ? 5 : 0;
    }

    public void func_176213_c(@Nullable World world, @Nullable BlockPos pos, @Nullable IBlockState state) {
        super.func_176213_c(world, pos, state);
        World world2 = world;
        if (world2 == null) {
            Intrinsics.throwNpe();
        }
        BlockPos blockPos = pos;
        if (blockPos == null) {
            Intrinsics.throwNpe();
        }
        IBlockState iBlockState = state;
        if (iBlockState == null) {
            Intrinsics.throwNpe();
        }
        world2.func_184138_a(blockPos, iBlockState, state, 3);
    }

    public boolean removedByPlayer(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player, boolean willHarvest) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (world.field_72995_K) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof IRecordWire) {
            ConnectionHelper.INSTANCE.clearConnections(world, (IRecordWire)te);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public BlockStrobeLight(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Material material = Material.field_151575_d;
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"Material.WOOD");
        super(material, name);
        this.func_149711_c(2.75f);
        this.func_149752_b(4.0f);
    }

    @Override
    public void bindTESR() {
        TESRProvider.DefaultImpls.bindTESR(this);
    }

    @Override
    public void registerTESRItemStacks(@NotNull ModBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
        TESRProvider.DefaultImpls.registerTESRItemStacks(this, block);
    }

    @Override
    public void registerTileEntity(@NotNull Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        TESRProvider.DefaultImpls.registerTileEntity(this, block);
    }

    @Override
    public void registerItemModel(@NotNull ModBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
        ItemModelProvider.DefaultImpls.registerItemModel(this, block);
    }
}

